/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.sfp.surveillance;

import com.ibm.hsc.common.util.PartitionInfo;
import com.ibm.hsc.sfp.surveillance.SurveillanceEventType;
import com.ibm.hsc.sfp.surveillance.SurveillancePartitionConnectionState;
import java.util.HashMap;
import java.util.Iterator;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.UnsignedInt8;

public class SurveillancePartitionState {
    public static final short CIM_PARTITION_STATE_RUNNING = 2;
    private UnsignedInt8 cimState;
    private SurveillancePartitionConnectionState stableConnectionState;
    private SurveillanceEventType lastEventType;
    private String userName;
    private boolean cimInfoValid;
    private boolean hasBeenConnected;
    private boolean notYetConnectedEventHasBeenQueued;
    private HashMap adapterLastEventTypes = new HashMap();
    private HashMap adapterStableStates = new HashMap();
    private HashMap adapterHasBeenConnecteds = new HashMap();
    private HashMap adapterHasQueuedNYCs = new HashMap();

    SurveillancePartitionState(UnsignedInt8 unsignedInt8, SurveillancePartitionConnectionState surveillancePartitionConnectionState, SurveillanceEventType surveillanceEventType, String string) {
        this.cimState = unsignedInt8;
        this.stableConnectionState = surveillancePartitionConnectionState;
        this.lastEventType = surveillanceEventType;
        this.userName = string;
        this.cimInfoValid = true;
        this.notYetConnectedEventHasBeenQueued = false;
        this.hasBeenConnected = surveillancePartitionConnectionState != null && surveillancePartitionConnectionState.equals(SurveillancePartitionConnectionState.CONNECTED);
    }

    SurveillancePartitionState(SurveillancePartitionConnectionState surveillancePartitionConnectionState, SurveillanceEventType surveillanceEventType, String string) {
        if (string == null) {
            this.lastEventType = surveillanceEventType;
            this.stableConnectionState = surveillancePartitionConnectionState;
            this.hasBeenConnected = surveillancePartitionConnectionState != null && surveillancePartitionConnectionState.equals(SurveillancePartitionConnectionState.CONNECTED);
        } else {
            this.adapterLastEventTypes.put(string, surveillanceEventType);
            this.adapterStableStates.put(string, surveillancePartitionConnectionState);
            if (surveillancePartitionConnectionState != null && surveillancePartitionConnectionState.equals(SurveillancePartitionConnectionState.CONNECTED)) {
                this.adapterHasBeenConnecteds.put(string, Boolean.TRUE);
            } else {
                this.adapterHasBeenConnecteds.put(string, Boolean.FALSE);
            }
        }
        this.cimInfoValid = false;
        this.notYetConnectedEventHasBeenQueued = false;
    }

    public static void main(String[] stringArray) {
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        boolean bl = false;
        stringBuffer.append("(");
        stringBuffer.append("lastEventType = ");
        if (this.lastEventType != null) {
            stringBuffer.append(this.lastEventType.toString());
        } else {
            stringBuffer.append("null");
        }
        stringBuffer.append(", ");
        stringBuffer.append("adapterLastEventTypes = (");
        bl = false;
        Iterator iterator = this.adapterLastEventTypes.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (bl) {
                stringBuffer.append(", ");
            } else {
                bl = true;
            }
            stringBuffer.append('(');
            stringBuffer.append(string);
            stringBuffer.append(',');
            stringBuffer.append(this.adapterLastEventTypes.get(string));
            stringBuffer.append(')');
        }
        stringBuffer.append("), ");
        stringBuffer.append("adapterStableStates = (");
        bl = false;
        iterator = this.adapterStableStates.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (bl) {
                stringBuffer.append(", ");
            } else {
                bl = true;
            }
            stringBuffer.append('(');
            stringBuffer.append(string);
            stringBuffer.append(',');
            stringBuffer.append(this.adapterStableStates.get(string));
            stringBuffer.append(')');
        }
        stringBuffer.append("), ");
        stringBuffer.append("adapterHasBeenConnecteds = (");
        bl = false;
        iterator = this.adapterHasBeenConnecteds.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (bl) {
                stringBuffer.append(", ");
            } else {
                bl = true;
            }
            stringBuffer.append('(');
            stringBuffer.append(string);
            stringBuffer.append(',');
            stringBuffer.append(this.adapterHasBeenConnecteds.get(string));
            stringBuffer.append(')');
        }
        stringBuffer.append("), ");
        stringBuffer.append("adapterHasQueuedNYCs = (");
        bl = false;
        iterator = this.adapterHasQueuedNYCs.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (bl) {
                stringBuffer.append(", ");
            } else {
                bl = true;
            }
            stringBuffer.append('(');
            stringBuffer.append(string);
            stringBuffer.append(',');
            stringBuffer.append(this.adapterHasQueuedNYCs.get(string));
            stringBuffer.append(')');
        }
        stringBuffer.append("), ");
        stringBuffer.append("stableConnectionState = ");
        if (this.stableConnectionState != null) {
            stringBuffer.append(this.stableConnectionState.toString());
        } else {
            stringBuffer.append("null");
        }
        stringBuffer.append(", ");
        stringBuffer.append("hasBeenConnected = ");
        stringBuffer.append(String.valueOf(this.hasBeenConnected));
        stringBuffer.append(", ");
        stringBuffer.append("cimInfoValid = ");
        stringBuffer.append(String.valueOf(this.cimInfoValid));
        stringBuffer.append(", ");
        stringBuffer.append("userName = ");
        if (this.userName != null) {
            stringBuffer.append(this.userName);
        } else {
            stringBuffer.append("null");
        }
        stringBuffer.append(", ");
        stringBuffer.append("cimState = ");
        if (this.cimState != null) {
            stringBuffer.append(this.cimState.toString());
        } else {
            stringBuffer.append("null");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    synchronized SurveillancePartitionConnectionState getStableConnectionState(String string) {
        SurveillancePartitionConnectionState surveillancePartitionConnectionState = null;
        surveillancePartitionConnectionState = string == null ? this.stableConnectionState : (SurveillancePartitionConnectionState)this.adapterStableStates.get(string);
        return surveillancePartitionConnectionState;
    }

    boolean getHasQueuedNYC(String string) {
        boolean bl = false;
        Boolean bl2 = null;
        if (string == null) {
            bl = this.notYetConnectedEventHasBeenQueued;
        } else {
            bl2 = (Boolean)this.adapterHasQueuedNYCs.get(string);
            if (bl2 != null) {
                bl = bl2;
            }
        }
        return bl;
    }

    void setHasQueuedNYC(boolean bl, String string) {
        if (string == null) {
            this.notYetConnectedEventHasBeenQueued = bl;
        } else {
            this.adapterHasQueuedNYCs.put(string, new Boolean(bl));
        }
    }

    synchronized SurveillanceEventType getLastEventType(String string) {
        SurveillanceEventType surveillanceEventType = null;
        surveillanceEventType = string == null ? this.lastEventType : (SurveillanceEventType)this.adapterLastEventTypes.get(string);
        return surveillanceEventType;
    }

    synchronized String getUserName() throws CIMException {
        if (this.cimInfoValid) {
            return this.userName;
        }
        throw new CIMException("");
    }

    synchronized boolean isRunning() throws CIMException {
        if (this.cimInfoValid) {
            return this.cimState.shortValue() == 2;
        }
        throw new CIMException("");
    }

    synchronized boolean hasBeenConnected(String string) {
        boolean bl = false;
        Boolean bl2 = null;
        if (string == null) {
            bl = this.hasBeenConnected;
        } else {
            bl2 = (Boolean)this.adapterHasBeenConnecteds.get(string);
            if (bl2 != null) {
                bl = bl2;
            }
        }
        return bl;
    }

    synchronized void setLastEventType(SurveillanceEventType surveillanceEventType, String string) {
        if (string == null) {
            this.lastEventType = surveillanceEventType;
        } else {
            this.adapterLastEventTypes.put(string, surveillanceEventType);
        }
    }

    synchronized void setStableConnectionState(SurveillancePartitionConnectionState surveillancePartitionConnectionState, String string) {
        if (string == null) {
            this.stableConnectionState = surveillancePartitionConnectionState;
            if (!this.hasBeenConnected && surveillancePartitionConnectionState != null && surveillancePartitionConnectionState.equals(SurveillancePartitionConnectionState.CONNECTED)) {
                this.hasBeenConnected = true;
            }
        } else {
            this.adapterStableStates.put(string, surveillancePartitionConnectionState);
            if (surveillancePartitionConnectionState != null && surveillancePartitionConnectionState.equals(SurveillancePartitionConnectionState.CONNECTED)) {
                this.adapterHasBeenConnecteds.put(string, Boolean.TRUE);
            }
        }
    }

    synchronized void setCIMInfo(PartitionInfo partitionInfo) {
        this.cimState = partitionInfo.getState();
        this.userName = partitionInfo.getUserName();
        this.cimInfoValid = true;
    }

    UnsignedInt8 getCIMState() {
        return this.cimState;
    }
}

